/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="artifacts", name="RLArtifacts", category="")
public class ModConfig {
    public static General general = new General();
    public static Client client = new Client();

    @Mod.EventBusSubscriber(modid="artifacts")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("artifacts")) {
                ConfigManager.sync((String)"artifacts", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class Client {
        @Config.Comment(value={"tooltips are always shown when enabled"})
        public boolean alwaysShowTooltip = false;
    }

    public static class General {
        @Config.Name(value="Underground Chest Chance")
        @Config.Comment(value={"Chance per chunk that a random chest attempts to generate underground (Values higher than 1 means chests will attempt to generate multiple times, 0 disables this.)"})
        @Config.RangeDouble(min=0.0)
        public double undergroundChestChance = 0.25;
        @Config.Name(value="Underground Chest Maximum Y Level")
        @Config.Comment(value={"Maximum Y Level that underground chests will randomly attempt to generate at."})
        @Config.RangeInt(min=0)
        public int undergroundChestMaxY = 45;
        @Config.Name(value="Underground Chest Generate Upwards")
        @Config.Comment(value={"If true, chests will attempt to generate on the first open solid block from the bottom-up, otherwise from the top-down"})
        public boolean undergroundChestBottomUp = true;
        @Config.Name(value="Underground Chest Dimensions")
        @Config.Comment(value={"List of dimension ID's that underground chests will randomly attempt to spawn in."})
        @Config.RequiresMcRestart
        public Integer[] undergroundChestDimensions = new Integer[]{0};
        @Config.Name(value="Underground Chest Mimic Chance")
        @Config.Comment(value={"Chance for an underground chest generated by this mod to instead be spawned as a Mimic."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double undergroundChestMimicRatio = 0.0;
        @Config.Name(value="Unlooted Chest Mimic Chance")
        @Config.Comment(value={"Chance for an unlooted (Ex. can not be opened in spectator mode) chest to be replaced by a Mimic upon a player opening or breaking the chest (0 disables this.)"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double unlootedChestMimicRatio = 0.05;
        @Config.Name(value="Unlooted Chest Mimic Dimensions")
        @Config.Comment(value={"List of dimension ID's that unlooted chests have a chance to be replaced by a Mimic in."})
        @Config.RequiresMcRestart
        public Integer[] unlootedChestDimensions = new Integer[]{0};
        @Config.Name(value="Star Cloak Cooldown")
        @Config.Comment(value={"Cooldown in ticks after the Star Cloak triggers before it can attempt again."})
        @Config.RangeInt(min=0)
        public int starCloakCooldown = 20;
        @Config.Name(value="Star Cloak Minimum Stars")
        @Config.Comment(value={"Minimum amount of falling stars to spawn when a player is hit while wearing a star cloak."})
        @Config.RangeInt(min=0)
        public int starCloakStarsMin = 2;
        @Config.Name(value="Star Cloak Maximum Stars")
        @Config.Comment(value={"Maximum amount of falling stars to spawn when a player is hit while wearing a star cloak."})
        @Config.RangeInt(min=1)
        public int starCloakStarsMax = 6;
        @Config.Name(value="Star Cloak Falling Star Damage")
        @Config.Comment(value={"Amount of damage to deal to entities hit by a falling star."})
        @Config.RangeInt(min=1)
        public int starCloakDamage = 8;
        @Config.Name(value="Star Cloak Indirect Damage")
        @Config.Comment(value={"Should the Star Cloak activate on indirect damage (Ex. Arrows) as well, or only on melee damage."})
        public boolean starCloakIndirect = true;
        @Config.Name(value="Attack Damage Operation")
        @Config.Comment(value={"Operation to apply to the attack damage boost (0 = Add to base, 1 = Multiply base, 2 = Multiply final"})
        @Config.RangeInt(min=0, max=2)
        public int attackDamageOperation = 0;
        @Config.Name(value="Attack Damage Value")
        @Config.Comment(value={"Attack damage boost given for wearing the power glove, mechanical glove, or fire gauntlet."})
        @Config.RangeDouble(min=0.0)
        public double attackDamageBoost = 2.0;
        @Config.Name(value="Attack Speed Operation")
        @Config.Comment(value={"Operation to apply to the attack speed boost (0 = Add to base, 1 = Multiply base, 2 = Multiply final"})
        @Config.RangeInt(min=0, max=2)
        public int attackSpeedOperation = 1;
        @Config.Name(value="Attack Speed Value")
        @Config.Comment(value={"Attack speed boost given for wearing the feral claws, mechanical glove, or fire gauntlet."})
        @Config.RangeDouble(min=0.0)
        public double attackSpeedBoost = 0.25;
        @Config.Name(value="Luck Operation")
        @Config.Comment(value={"Operation to apply to the luck boost (0 = Add to base, 1 = Multiply base, 2 = Multiply final"})
        @Config.RangeInt(min=0, max=2)
        public int luckOperation = 0;
        @Config.Name(value="Luck Value")
        @Config.Comment(value={"Luck boost given for wearing the lucky clover."})
        @Config.RangeDouble(min=0.0)
        public double luckBoost = 2.0;
        @Config.Name(value="Antidote Vessel Maximum Amplifier")
        @Config.Comment(value={"Maximum amplifier of negative effects while wearing the Antidote Vessel (Amplifier 0 = Level 1.)"})
        @Config.RangeInt(min=0)
        public int vesselMaxAmplifier = 1;
        @Config.Name(value="Antidote Vessel Maximum Duration")
        @Config.Comment(value={"Maximum duration of negative effects while wearing the Antidote Vessel (0 means effects are just removed.)"})
        @Config.RangeInt(min=0, max=12000)
        public int vesselMaxDuration = 1200;
        @Config.Name(value="Antidote Vessel Blacklisted Effects")
        @Config.Comment(value={"Potion Effects that the Antidote Vessel will not effect."})
        public String[] vesselBlacklist = new String[0];
        @Config.Name(value="Thorn Pendant Chance")
        @Config.Comment(value={"Chance for the Thorn Pendant to trigger on hit."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double thornChance = 0.35;
        @Config.Name(value="Flame Pendant Chance")
        @Config.Comment(value={"Chance for the Flame Pendant to trigger on hit."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double flameChance = 0.25;
        @Config.Name(value="Shock Pendant Chance")
        @Config.Comment(value={"Chance for the Shock Pendant to trigger on hit."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double shockChance = 0.15;
        @Config.Name(value="Pendant Cooldown")
        @Config.Comment(value={"Cooldown in ticks after a Pendant triggers before it can attempt again."})
        @Config.RangeInt(min=0)
        public int pendantCooldown = 10;
        @Config.Name(value="Sacrificial Amulet Required Charge")
        @Config.Comment(value={"How many kills are required before the Sacrificial Amulet is charged."})
        @Config.RangeInt(min=10, max=10000)
        public int sacrificialCharge = 99;
        @Config.Name(value="Sacrifical Amulet Tooltip")
        @Config.Comment(value={"Should the Sacrificial Amulet use its custom tooltip info."})
        public boolean sacrificialTooltip = true;
        @Config.Name(value="Sacrifical Amulet Charge Visibility")
        @Config.Comment(value={"Should the current charge of the Sacrificial Amulet be visible in the tooltip."})
        public boolean sacrificialVisible = true;
        @Config.Name(value="Sacrifical Amulet Total Visibility")
        @Config.Comment(value={"Should the total required charge of the Sacrificial Amulet be visible in the tooltip."})
        public boolean sacrificialChargeShowTotal = true;
        @Config.Name(value="Pocket Piston Knockback Multiplier")
        @Config.Comment(value={"How much to multiply knockback when using the pocket piston."})
        @Config.RangeDouble(min=1.0, max=100.0)
        public double pistonKnockback = 2.0;
        @Config.Name(value="Register Legacy Items")
        @Config.Comment(value={"Registers baubles from the original Artifacts that overlap with BountifulBaubles (Cobalt Shield, Lucky Horseshoe, etc)"})
        public boolean registerLegacyItems = false;
    }
}

